#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>
#include <math.h>

#define ADS1115_ADDR 0x48

int main() {
    int fd = open("/dev/i2c-1", O_RDWR);
    if (fd < 0) return 1;
    if (ioctl(fd, I2C_SLAVE, ADS1115_ADDR) < 0) return 1;
    
    while(1) {
        unsigned char config[3] = {0x01, 0xC2, 0x83};
        unsigned char result[2];
        
        write(fd, config, 3);
        usleep(8000);
        
        unsigned char reg[1] = {0x00};
        write(fd, reg, 1);
        read(fd, result, 2);
        
        int16_t adc = (result[0] << 8) | result[1];
        float voltage = adc * 0.125 / 1000.0;
        float ntc_r = (3.3 * 10000.0 / voltage) - 20000.0;
        float temp = 1.0 / (log(ntc_r / 10000.0) / 3950.0 + 1.0 / 298.15) - 273.15;
        
        printf("Temp: %.1fC\n", temp);
        sleep(1);
    }
    
    return 0;
}
